MplusAutomation
===============

The `MplusAutomation` package leverages the flexibility of the `R`
language to automate latent variable model estimation and
interpretation using Mplus, a powerful latent variable modeling
program developed by Muthn and Muthn
(www.statmodel.com). Specifically, `MplusAutomation` provides routines
for creating related groups of models, running batches of models, and
extracting and tabulating model parameters and fit statistics. 

Installation
------------

You can install the latest release of `MplusAutomation` directly from
[CRAN](http://cran.r-project.org/package=MplusAutomation) by running 

```r
install.packages("MplusAutomation")
```

Alternately, if you want to try out the latest development
`MplusAutomation` code, you can install it straight from github using
Hadley Wickham's `devtools` package. If you do not have `devtools`
installed, first install it and then install `MplusAutomation`. 

```r
#install.packages("devtools")
require(devtools)

install_github("MplusAutomation", "michaelhallquist")
```

Questions
---------

For questions, answers, and updates on the status of the
`MplusAutomation` package, email or subscribe to the Google group
[list](https://groups.google.com/forum/#!forum/mplusautomation). 

Examples
--------

You can find a detailed example of how to use the `MplusAutomation`
package in the
[vignette](https://github.com/michaelhallquist/MplusAutomation/blob/master/inst/doc/Vignette.pdf)
located in the /inst/doc/ directory. 

You can also see the Wiki 
[Examples page](https://github.com/michaelhallquist/MplusAutomation/wiki/Examples).

