% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{clusterTracks}
\alias{clusterTracks}
\title{Cluster Tracks}
\usage{
clusterTracks(tracks, measures, scale = TRUE, ...)
}
\arguments{
\item{tracks}{the tracks that are to be clustered.}

\item{measures}{a function, or a vector of functions (see \link{TrackMeasures}). 
Each function is expected to 
return a single number given a single track.}

\item{scale}{logical indicating whether the measures values shall be scaled
using the function \code{\link[base]{scale}} before the clustering.}

\item{...}{additional parameters to be passed to \code{\link[stats]{hclust}}.}
}
\value{
An object of class *hclust*, see \code{\link[stats]{hclust}}.
}
\description{
Perform a hierarchical clustering of a set of tracks according to a given vector
of track measures.
}
\details{
The measures are applied to each of the tracks in the given
\emph{tracks} object. According to the resulting values, the tracks are 
clustered using a hierarchical clustering (see \code{\link[stats]{hclust}}).
If \code{scale} is \code{TRUE}, the measure values are scaled to mean value 
\eqn{0} and standard deviation \eqn{1} (per measure) before the clustering.
}
\examples{
## Cluster tracks according to the mean of their Hust exponents along X and Y

cells <- c(TCells,Neutrophils)
real.celltype <- rep(c("T","N"),c(length(TCells),length(Neutrophils)))
## Prefix each track ID with its cell class to evaluate the clustering visually
names(cells) <- paste0(real.celltype,seq_along(cells))
clust <- clusterTracks( cells, hurstExponent )
plot( clust )
## How many cells are "correctly" clustered?
sum( real.celltype == c("T","N")[cutree(clust,2)] )

}

