% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/periodDeathProbabilities.R,
%   R/mortalityTable.jointLives.R, R/mortalityTable.observed.R
\name{periodDeathProbabilities}
\alias{periodDeathProbabilities}
\alias{periodDeathProbabilities,mortalityTable.period-method}
\alias{periodDeathProbabilities,mortalityTable.ageShift-method}
\alias{periodDeathProbabilities,mortalityTable.trendProjection-method}
\alias{periodDeathProbabilities,mortalityTable.improvementFactors-method}
\alias{periodDeathProbabilities,mortalityTable.mixed-method}
\alias{periodDeathProbabilities,mortalityTable.jointLives-method}
\alias{periodDeathProbabilities,mortalityTable.observed-method}
\title{Return the (period) death probabilities of the life table for a given
observation year}
\usage{
periodDeathProbabilities(object, ..., ages = NULL, Period = 1975)

\S4method{periodDeathProbabilities}{mortalityTable.period}(object, ..., ages = NULL, Period = 1975)

\S4method{periodDeathProbabilities}{mortalityTable.ageShift}(object, ..., ages = NULL, Period = 1975)

\S4method{periodDeathProbabilities}{mortalityTable.trendProjection}(object, ..., ages = NULL, Period = 1975)

\S4method{periodDeathProbabilities}{mortalityTable.improvementFactors}(object, ..., ages = NULL, Period = 1975)

\S4method{periodDeathProbabilities}{mortalityTable.mixed}(object, ..., ages = NULL, Period = 1975)

\S4method{periodDeathProbabilities}{mortalityTable.jointLives}(
  object,
  ...,
  ageDifferences = c(),
  ages = NULL,
  Period = 1975
)

\S4method{periodDeathProbabilities}{mortalityTable.observed}(object, ..., ages = NULL, Period = 1975)
}
\arguments{
\item{object}{The life table object (class inherited from mortalityTable)}

\item{...}{Other parameters (currently unused)}

\item{ages}{Desired age range (if NULL, the probabilities of the age range provided by the table will be returned), missing ages will be filled with NA}

\item{Period}{The observation year for which the period death probabilities should be determined}

\item{ageDifferences}{A vector of age differences of all joint lives.}
}
\description{
Return the (period) death probabilities of the life table for a given
observation year
}
\section{Methods (by class)}{
\itemize{
\item \code{periodDeathProbabilities(mortalityTable.period)}: Return the (period) death probabilities
of the life table for a given observation year

\item \code{periodDeathProbabilities(mortalityTable.ageShift)}: Return the (period) death probabilities
of the life table for a given observation year

\item \code{periodDeathProbabilities(mortalityTable.trendProjection)}: Return the (period) death probabilities
of the life table for a given observation year

\item \code{periodDeathProbabilities(mortalityTable.improvementFactors)}: Return the (period) death probabilities
of the life table for a given observation year

\item \code{periodDeathProbabilities(mortalityTable.mixed)}: Return the (period) death probabilities
of the life table for a given observation year

\item \code{periodDeathProbabilities(mortalityTable.jointLives)}: Return the (period) death probabilities
of the joint lives mortality table for a given observation year

\item \code{periodDeathProbabilities(mortalityTable.observed)}: Return the (period) death probabilities
of the life table for a given observation year
If the observed mortality table does not provide data
for the desired period, the period closest to the
`Period` argument will be used and a warning printed.

}}
\examples{
mortalityTables.load("Austria_Annuities")
periodDeathProbabilities(AVOe2005R.male, Period = 1975)
periodDeathProbabilities(AVOe2005R.male, Period = 2017)

mortalityTables.load("Germany_Census")
table.JL = mortalityTable.jointLives(
    name = "ADSt 24/26 auf verbundene Leben",
    table = mort.DE.census.1924.26.male
)
periodDeathProbabilities(table.JL, Period = 2017, ageDifferences = c(1, 5, -5, 16))
periodDeathProbabilities(table.JL, Period = 2017, ageDifferences = c(0))
periodDeathProbabilities(table.JL, Period = 2017, ageDifferences = c(1, 5, 16))

}
