% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kannisto.R
\name{kannisto}
\alias{kannisto}
\title{Kannisto Method}
\usage{
kannisto(mx, est.ages = seq(80, 95, by = 5), proj.ages = seq(100, 130,
  by = 5))
}
\arguments{
\item{mx}{A vector or matrix of mortality rates. If it is a matrix,
rows correspond to age groups with rownames identifying the corresponding age as integers.
By default five-years age groups are assigned to rows if rownames are not given.}

\item{est.ages}{A vector of integers identifying the ages to be used 
for estimation. It should be a subset of rownames of \code{mx}.}

\item{proj.ages}{A vector of integers identifying the age groups for which mortality rates 
are to be projected.}
}
\value{
A vector or matrix containing the input mortality object \code{mx}
   extended by the extrapolated age groups.
}
\description{
Extrapolate given mortality rates using the original Kannisto method.
}
\details{
The function first estimates the original Kannisto parameters 
    by passing mortality rates for age groups \code{est.ages} into 
    the \code{\link{kannisto.estimate}} function.
    The estimated parameters are then passed to the projection function
    \code{\link{kannisto.predict}} to extrapolate into ages \code{proj.ages}.
    Lastly, the input mortality object is extended by results for the extrapolated ages. 
    If \code{proj.ages} contains age groups that are included in \code{mx},
    values for those age groups are overwritten.
}
\examples{
data(mxM, package = "wpp2017")
mx <- subset(mxM, name == "Burkina Faso")[,-(1:3)]
rownames(mx) <- c(0,1, seq(5, 100, by=5))
mxnew <- kannisto(mx)
ages <- as.integer(rownames(mxnew))
plot(ages, mxnew[,"2095-2100"], type="l", log="y", 
    xlab="age", ylab="mx", col="red")
lines(ages, mxnew[,"2010-2015"])

}
\references{
Thatcher, A. R., Kannisto, V. and Vaupel, J. W. (1998). The Force of Mortality at Ages 80 to 120, 
volume 5 of Odense Monographs on Population Aging Series. Odense, Denmark: Odense University Press.
}
\seealso{
\code{\link{kannisto.estimate}}, \code{\link{kannisto.predict}}, \code{\link{cokannisto}}
}
