% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeTransform.r
\name{computeTransform}
\alias{computeTransform}
\title{calculate an affine transformation matrix}
\usage{
computeTransform(x, y, type = c("rigid", "similarity", "affine", "tps"),
  reflection = FALSE, lambda = 1e-08, weights = NULL,
  centerweight = FALSE, threads = 1)
}
\arguments{
\item{x}{fix landmarks. Can be a k x m matrix or mesh3d.}

\item{y}{moving landmarks. Can be a k x m matrix or mesh3d.}

\item{type}{set type of affine transformation: options are  "rigid", "similarity" (rigid + scale) and "affine",}

\item{reflection}{logical: if TRUE "rigid" and "similarity" allow reflections.}

\item{lambda}{numeric: regularisation parameter of the TPS.}

\item{weights}{vector of length k, containing weights for each landmark (only used in type="rigid" or "similarity").}

\item{centerweight}{logical or vector of weights: if weights are defined and
centerweigths=TRUE, the matrix will be centered according to these weights instead of the
barycenter. If centerweight is a vector of length \code{nrow(x)}, the barycenter will be weighted accordingly.}

\item{threads}{number of threads to use in TPS interpolation.}
}
\value{
returns a 4x4 (3x3 in 2D case)  transformation matrix or an object of class "tpsCoeff" in case of type="tps".
}
\description{
calculate an affine transformation matrix
}
\details{
\code{x} and \code{y} can also be a pair of meshes with corresponding vertices.
}
\note{
all lines containing NA, or NaN are ignored in computing the transformation.
}
\examples{
data(boneData)
trafo <- computeTransform(boneLM[,,1],boneLM[,,2])
transLM <- applyTransform(boneLM[,,2],trafo)
}
\seealso{
\code{\link{rotonto}, link{rotmesh.onto}, \link{tps3d}}
}
