% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirror.r
\name{mirror}
\alias{mirror}
\alias{mirror.matrix}
\alias{mirror.mesh3d}
\title{mirror landmarks or triangular mesh in place}
\usage{
mirror(x, icpiter = 50, subsample = NULL, pcAlign = TRUE, mc.cores = 2)

\method{mirror}{matrix}(x, icpiter = 50, subsample = NULL, pcAlign = TRUE,
  mc.cores = 2)

\method{mirror}{mesh3d}(x, icpiter = 50, subsample = NULL, pcAlign = TRUE,
  mc.cores = 2)
}
\arguments{
\item{x}{k x 3 matrix or mesh3d}

\item{icpiter}{integer: number of iterations to match reflected configuration onto original one}

\item{subsample}{integer: use only a subset for icp matching}

\item{pcAlign}{if TRUE, the icp will be preceeded by an alignment of the principal axis (only used if icpiter > 0).}

\item{mc.cores}{use parallel processing to find best alignment to original shape.}
}
\value{
returns the reflected object
}
\description{
mirror landmarks or triangular mesh in place
}
\details{
reflect a mesh configuration at the plane spanned by its first 2 principal axis, then try to rigidily register the reflected configuration onto the original one using iterative closest point search to establish correspondences.
}
\examples{
data(boneData)
boneMir <- mirror(boneLM[,,1],icpiter=50,mc.cores=2)
## 2D Example:
require(shapes)
gorfMir <- mirror(gorf.dat[,,1])
plot(gorfMir,asp = 1)
points(gorf.dat[,,1],col=3)
\dontrun{
## now mirror a complete mesh
require(rgl)
skullMir <- mirror(skull_0144_ch_fe.mesh,icpiter=10,subsample = 30,mc.cores=2)
###compare result to original
wire3d(skull_0144_ch_fe.mesh,col=3)
wire3d(skullMir,col=2)
}
}

