% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-farming.R
\name{breed}
\alias{breed}
\alias{breed.default}
\alias{breed.Coe}
\title{Jitters Coe (and others) objects}
\usage{
breed(x, ...)

\method{breed}{default}(x, fac, margin = 2, size, rate = 1, ...)

\method{breed}{Coe}(x, fac, size, rate = 1, ...)
}
\arguments{
\item{x}{the object to permute}

\item{...}{useless here}

\item{fac}{a column, a formula or a column id from \verb{$fac}}

\item{margin}{numeric whether 1 or 2 (rows or columns)}

\item{size}{numeric the required size for the final object, same size by default}

\item{rate}{numeric the number of sd for \link{rnorm}, 1 by default.}
}
\description{
This methods applies column-wise on the \code{coe} of any
\link{Coe} object but relies on a function that can be used on any matrix. It
simply uses \link{rnorm} with the mean and sd calculated for every column (or row).
For a \code{Coe} object, on every colum, randomly generates coefficients values
centered on the mean of the column, and with a sd equals to it standard deviates
multiplied by \code{rate}.
}
\examples{
m <- matrix(1:12, nrow=3)
breed(m, margin=2, size=4)
breed(m, margin=1, size=10)

bot.f <- efourier(bot, 12)
bot.m <- breed(bot.f, size=80)
bot.m \%>\% PCA \%>\% plot

# breed fac wise
# bot.f \%>\%  breed(~type, size=50) \%>\% PCA \%>\% plot(~type)
}
\seealso{
Other farming: 
\code{\link{perm}()}
}
\concept{farming}
