% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_coreFunctions.R
\name{createEffectsObject}
\alias{createEffectsObject}
\title{createEffectsObject}
\usage{
createEffectsObject(effectInit, checkProcessState = NULL)
}
\arguments{
\item{effectInit}{A list of "effects", where each effect to be included is specified as a
further list that contains the effect name and the additional parameters it needs.
Effects without further parameters only contain the effect name (e.g., loops).}

\item{checkProcessState}{For internal use only.}
}
\value{
An object of class "effectsList.monan".
}
\description{
Specifies the model with endogenous and exogenous predictors.
The predictors in the model are called “effects”.
}
\examples{
# create an effects object
myEffects <- createEffectsObject(
  list(
    list("loops"),
    list("reciprocity_min"),
    list("dyadic_covariate", attribute.index = "sameRegion"),
    list("alter_covariate", attribute.index = "size"),
    list("resource_covar_to_node_covar",
      attribute.index = "region",
      resource.attribute.index = "sex"
    ),
    list("loops_resource_covar", resource.attribute.index = "sex")
  )
)
}
