% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Functions.R
\name{MoE_plotGate}
\alias{MoE_plotGate}
\title{Plot MoEClust Gating Network}
\usage{
MoE_plotGate(res, type = "l", xlab = "Observation",
  ylab = expression(tau[g]), ylim = c(0, 1), col = NULL, ...)
}
\arguments{
\item{res}{An object of class \code{"MoEClust"} generated by \code{\link{MoE_clust}}, or an object of class \code{"MoECompare"} generated by \code{\link{MoE_compare}}.}

\item{type, xlab, ylab, ylim, col}{These graphical parameters retain their definitions from \code{\link[graphics]{matplot}}.}

\item{...}{Catches unused arguments, or additional arguments to be passed to \code{\link[graphics]{matplot}}.}
}
\value{
A plot of the gating network of the fitted model.
}
\description{
Plots the gating network for fitted MoEClust models, i.e. the observation index against the mixing proportions for that observation, coloured by cluster.
}
\note{
\code{\link{plot.MoEClust}} is a wrapper to \code{\link{MoE_plotGate}} which accepts the default arguments, and also produces other types of plots.

By default, the noise component (if any) will be coloured \code{"grey65"}.
}
\examples{
data(ais)
res <- MoE_clust(ais[,3:7], gating= ~ sex, G=3, modelNames="EEE", network.data=ais,
                 noise.init=sample(c(TRUE, FALSE), replace=TRUE, size=nrow(ais)))
MoE_plotGate(res)
}
\seealso{
\code{\link{MoE_clust}}, \code{\link{plot.MoEClust}}, \code{\link[graphics]{matplot}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@ucd.ie}>
}
\keyword{plotting}
