% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mutations.R
\name{vcf_to_mixvir}
\alias{vcf_to_mixvir}
\title{Convert Sample VCF to MixviR Input Format}
\usage{
vcf_to_mixvir(infile, max.vcf.size = 1e+08)
}
\arguments{
\item{infile}{Path to a vcf file that must contain "DP" and "AD" flags in the FORMAT field.}

\item{max.vcf.size}{Max memory usage (in bytes) allowed when reading in vcf file (from vcfR).}
}
\value{
Data frame with cols "CHR"	"POS"	"REF"	"ALT"	"DP" "REF_COUNT"	"ALT_COUNT"
}
\description{
Create data frame with relevant contents of VCF
}
\examples{
vcf_to_mixvir(infile = system.file("extdata", "vcfs", "Sample1_04182021.vcf.gz", package="MixviR"))
}
\keyword{VCF}
