% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{explore_mutations}
\alias{explore_mutations}
\title{MixviR Shiny Dashboard}
\usage{
explore_mutations(
  muts.df,
  dates = NULL,
  lineage.muts = NULL,
  read.muts.from = NULL,
  all.target.muts = FALSE
)
}
\arguments{
\item{muts.df}{A data frame (produced by \code{call_mutations()}) storing mutation information for samples to analyze. Must contain columns SAMP_NAME, CHR, POS, GENE, ALT_ID, AF, & DP. Alternatively, the mutation data can be read in from a (tab-separated) file with the \code{read.muts.from()} argument. See the \emph{write.mut.table} argument in \code{call_mutations()}.}

\item{dates}{Path to optional csv file with cols "SAMP_NAME", "LOCATION", and "DATE". Sample names need to match those in \emph{muts.df} data frame created by \code{call_mutations()}. Dates should be provided in the format \emph{mmddyyyy}.}

\item{lineage.muts}{Path to optional csv file with required cols "Gene", "Mutation", and  "Lineage" defining mutations associated with lineages of interest. See example file at "https://github.com/mikesovic/MixviR/blob/main/mutation_files/outbreak_20211202.csv". Additional columns will be ignored.}

\item{read.muts.from}{An alternative to \emph{muts.df} for providing input. If a data frame generated by \code{call_mutations()} was previously written to a (tab-separated) file (see \emph{write.mut.table} in \code{call_mutations()}), the mutation data can be read in from that file by providing its path. The fields "SAMP_NAME, CHR, POS, GENE, ALT_ID, AF, DP" must be present (additional fields will be ignored).}

\item{all.target.muts}{Logical to indicate whether results for all target mutations were written to the output of the \code{call_mutations()} function. See \emph{write.all.targets} option in \code{call_mutations()}. Default FALSE. If TRUE, more informative sequencing depth information can be provided in the dashboard.}
}
\value{
Shiny Dashboard to Explore Data
}
\description{
Open dashboard to explore mutation data generated with \code{call_mutations()}.
}
\examples{
if (interactive()) {explore_mutations(read.muts.from = system.file("extdata", 
                                                                   "sample_mutations.tsv", 
                                                                   package = "MixviR"),
                                      lineage.muts = system.file("extdata", 
                                                                 "example_lineage_muts.csv", 
                                                                 package = "MixviR"))}
if (interactive()) {explore_mutations(read.muts.from = system.file("extdata", 
                                                                   "sample_mutations.tsv", 
                                                                   package = "MixviR"), 
                                      dates = system.file("extdata", 
                                                          "example_location_date.csv", 
                                                          package = "MixviR"), 
                                      lineage.muts = system.file("extdata", 
                                                                 "example_lineage_muts.csv", 
                                                                 package = "MixviR"))}
}
\keyword{shiny}
