% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hyperpars.R
\name{hcmm_hyperpar}
\alias{hcmm_hyperpar}
\title{Generate a list of hyperparameters}
\usage{
hcmm_hyperpar(hcmmdat = NULL, q = ncol(hcmmdat$Y), cx = hcmmdat$cx,
  alpha_a = 0.5, alpha_b = 0.5, beta_x_a = 0.5, beta_x_b = 0.5,
  beta_y_a = 0.5, beta_y_b = 0.5, tau_a = 0.5, tau_b = 0.5, v = q + 1,
  w = q + 2, Sigma0 = diag(1, q)/v, gamma = 1/cx, sigma2_0beta = 10)
}
\arguments{
\item{hcmmdat}{An \code{hcmm_data} object}

\item{q}{The number of continuous variables}

\item{cx}{A length p vector (where p is the number of categorical variables). cx[j]
is the number of distinct values taken by X[,j]}

\item{alpha_a,alpha_b}{Gamma prior on top-level concentration parameter,
where E(alpha) = alpha_a/alpha_b}

\item{beta_x_a,beta_x_b}{Gamma prior on X model concentration parameter}

\item{beta_y_a,beta_y_b}{Gamma prior on Y model concentration parameter}

\item{tau_a,tau_b}{Gamma prior on coefficient precision parameters}

\item{v,w}{Degree of freedom parameters in the hierarchical inverse-Wishart/Wishart prior}

\item{Sigma0}{Centering matrix in the hierarchical inverse-Wishart/Wishart prior}

\item{gamma}{Parameter of the symmetric Dirichlet priors in the product multinomial kernel.
(Should be a length p vector.)}

\item{sigma2_0beta}{Variance of the prior on B0}
}
\value{
A list of hyperparameters
}
\description{
Generates a list of hyperparameters for use in \code{hcmm_impute}. Specifying
only \code{hcmmdat} or \code{q} AND \code{cx} will generate default values
(see citation).
}

