% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixregression.R
\name{mixlinrb_bi}
\alias{mixlinrb_bi}
\title{Robust EM algorithm to fit the mixture of linear regression based on bisquare function}
\usage{
mixlinrb_bi(x, y, m = 2, numini = 20)
}
\arguments{
\item{x}{explanatory variables matrix with rows for each observation}

\item{y}{response variable vector}

\item{m}{number of components, default is 2}

\item{numini}{number of initial values, default is 20.}
}
\value{
theta: estimated parameters matrix for the best estimator (the estimated value with most initial values converge to),
the columns are beta(intercept, slopes), sigma, proportion for each component
estall: all estimated parameters
uniqueest: unique estimated parameters
countuniqueest: number of unique estimated parameters
uniqueestindex: which initial values gives the unique estimators
bestindex: index of initial value gives the best estimated parameter
estindex: matrix of each initial value converge to which set of estimated parameters.
}
\description{
mixlinrb_bi estimates the mixture regression parameters robustly using bisquare function based on multiple initial values. The solution is found by the modal solution
}
\examples{
library(fpc)
data('tonedata')
y=tonedata$tuned
x=tonedata$stretchratio
k=160;x[151:k]=0;y[151:k]=5
est_bi=mixlinrb_bi(x,y,2,numini=2);
bi=est_bi$theta
}
