% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smnr.R
\name{gen_mixreg}
\alias{gen_mixreg}
\title{Semiparametric Mixture Data Generator}
\usage{
gen_mixreg(n, p, var, u)
}
\arguments{
\item{n}{number of observations}

\item{p}{probability of an observation in first component}

\item{var}{variance of the observations}

\item{u}{grid point}
}
\value{
list of x,y, true mean functions and true interpolated mean functions.
}
\description{
Generate data from two-component semiparametric mixture of regression models with
m(x) functions:\cr \eqn{m_1(x) = 4 - sin(2\pi x)} and \eqn{m_2(x) = 1.5 + cos(3\pi x)}, used in the examples for
backfitlocal,backfitglobal etc.
}
\examples{
n=100;
u=seq(from=0,to=1,length=100);
true_p=c(0.3,0.7);
true_var=c(0.09,0.16);
out=gen_mixreg(n,true_p[1],true_var,u);
}
