% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMlogconcave.R
\name{EMlogconc}
\alias{EMlogconc}
\title{Clustering with Mixtures of Log-concave Distributions using EM Algorithm
(Univariate)}
\usage{
EMlogconc(x, k, EMnorm)
}
\arguments{
\item{x}{Observations. Given as col vectors of x.}

\item{k}{the number of components.}

\item{EMnorm}{Output  of EMnorm function}
}
\value{
List of logL:log-likelihood; pis: estimated component proportions;
f:component densities at x.
}
\description{
Does EM by computing the logconcave MLE for each component in the M-step,
with initial values from estimations from normal mixture assumption.
This function will need the output from EMnorm function.
}
\examples{
m=2;
set.seed(4)
x=rnorm(100,2,sqrt(2));x=matrix(x,nrow=100);x[1:60]=x[1:60]+5;
EMnorm = EMnormal(x,m);
EMlogc = EMlogconc(x,m,EMnorm);

}
