% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterStrategy.R
\name{clusterStrategy}
\alias{clusterStrategy}
\alias{clusterSemiSEMStrategy}
\alias{clusterSEMStrategy}
\alias{clusterFastStrategy}
\title{A strategy is a multistage empirical process for finding a
good estimate in the clustering estimation process.}
\usage{
clusterStrategy(nbTry = 1, nbInit = 5, initMethod = "class",
  initAlgo = "EM", nbInitIteration = 20, initEpsilon = 0.01,
  nbShortRun = 5, shortRunAlgo = "EM", nbShortIteration = 100,
  shortEpsilon = 1e-04, longRunAlgo = "EM", nbLongIteration = 1000,
  longEpsilon = 1e-07)

clusterSemiSEMStrategy()

clusterSEMStrategy()

clusterFastStrategy()
}
\arguments{
\item{nbTry}{number of estimation to attempt.}

\item{nbInit}{Integer defining the number of initialization to try. Default value: 5.}

\item{initMethod}{Character string with the initialization method, see [\code{\link{clusterInit}}]$
for possible values. Default value: "class".}

\item{initAlgo}{Character string with the algorithm to use in the initialization stage,
[\code{\link{clusterAlgo}}] for possible values. Default value: "EM".}

\item{nbInitIteration}{Integer defining the maximal number of iterations in
initialization algorithm. If \code{initAlgo} = "EM", "CEM" or "SemiSEM", this
is the number of iterations if \code{initAlgo} = "SEM". Default value: 20.}

\item{initEpsilon}{Real defining the epsilon value for the algorithm.
\code{initEpsilon} is not used by the \code{SEM} algorithm. Default value: 0.01.}

\item{nbShortRun}{Integer defining the number of short run to try
(the strategy launch an initialization before each short run). Default value: 5.}

\item{shortRunAlgo}{A character string with the algorithm to use in the short
run stage. Default value: "EM".}

\item{nbShortIteration}{Integer defining the maximal number of iterations in
a short run if \code{shortRunAlgo} = "EM", "CEM" or "semiSEM", or the number
of iterations if \code{shortRunAlgo} = "SEM". Default value: 100.}

\item{shortEpsilon}{Real defining the epsilon value for the algorithm.
\code{shortEpsilon} is not used by the \code{SEM} algorithm. Default value: 1e-04.}

\item{longRunAlgo}{A character string with the algorithm to use in the long run stage
Default value: "EM".}

\item{nbLongIteration}{Integer defining the maximal number of iterations in the short runs
if \code{shortRunAlgo} = "EM", "CEM" or "SemiSEM", or the number of iterations
if \code{shortRunAlgo} = "SEM". Default value: 1000.}

\item{longEpsilon}{Real defining the epsilon value for the algorithm.
\code{longEpsilon} is not used by the \code{SEM} algorithm. Default value: 1e-07.}
}
\value{
a [\code{\linkS4class{ClusterStrategy}}] object
}
\description{
A strategy is a way to find a good estimate of the parameters of a mixture model
when using an EM algorithm or its variants. A ``try'' is composed of three stages
\itemize{
  \item \code{nbShortRun} short iterations of the initialization step and
   of the \code{EM}, \code{CEM}, \code{SEM} or \code{SemiSEM} algorithm.
  \item \code{nbInit} initializations using the [\code{\link{clusterInit}}]
  method.
  \item A long run of the \code{EM}, \code{CEM}, \code{SEM} or \code{SemiSEM} algorithm.
}
For example if \code{nbInit} is 5 and \code{nbShortRun} is also 5, there will
be 5 packets of 5 models initialized. In each packet, the best model will be
ameliorated using a short run. Among the 5 models ameliorated the best one will be
estimated until convergence using a long run. In total there will be 25 initializations,
5 short runs and one long-run.

\code{clusterSemiSEMStrategy()} create an instance of [\code{\linkS4class{ClusterStrategy}}]
for users with many missing values uning a semiSem algorithm.

\code{clusterSEMStrategy()} create an instance of [\code{\linkS4class{ClusterStrategy}}]
for users with many missing values using a SEM algorithm.

\code{clusterFastStrategy()} create an instance of [\code{\linkS4class{ClusterStrategy}}] for impatient user.
}
\details{
The whole process can be repeated at least \code{nbTry} times. If a try
success, the estimated model is returned, otherwise an empty model is returned
(with an error message).
}
\examples{
   clusterStrategy()
   clusterStrategy(longRunAlgo= "CEM", nbLongIteration=100)
   clusterStrategy(nbTry = 1, nbInit= 1, shortRunAlgo= "SEM", nbShortIteration=100)

   clusterSemiSEMStrategy()

   clusterSEMStrategy()

   clusterFastStrategy()

}
\author{
Serge Iovleff
}
