% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmm.R
\name{kmm}
\alias{kmm}
\title{Create an instance of the [\code{\linkS4class{KmmModel}}] class}
\usage{
kmm(data, nbCluster = 2, dim = 10, models = "kmm_pk_s",
  kernelName = "Gaussian", kernelParameters = c(1),
  kernelComputation = TRUE, strategy = kmmStrategy(), criterion = "ICL",
  nbCore = 1)
}
\arguments{
\item{data}{frame or matrix containing the data. Rows correspond to observations
and columns correspond to variables.}

\item{nbCluster}{[\code{\link{vector}}] listing the number of clusters to test.}

\item{dim}{integer giving the dimension of the Gaussian density. Default is 10.}

\item{models}{[\code{\link{vector}}] of model names to run. By default only
"kmm_pk_s" is estimated. All the model names are given by the method
[\code{\link{kmmNames}}].}

\item{kernelName}{string with a kernel name. Possible values:
"Gaussian", "polynomial", "Laplace", "linear", "rationalQuadratic_", "Hamming".
Default is "Gaussian".}

\item{kernelParameters}{[\code{\link{vector}}] with the parameters of
the chosen kernel. Default is c(1).}

\item{kernelComputation}{[\code{\link{logical}}] parameter. Should be \code{TRUE}
if the Gram matrix is to be computed (faster but can be memory consuming), \code{FALSE}
otherwise (times consuming). Default is \code{TRUE}. Recall that Gram matrix
is a square matrix of size nbSample.}

\item{strategy}{a [\code{\linkS4class{ClusterStrategy}}] object containing
the strategy to run. [\code{\link{kmmStrategy}}]() method by default.}

\item{criterion}{character defining the criterion to select the best model.
The best model is the one with the lowest criterion value.
Possible values: "BIC", "AIC", "ICL", "ML". Default is "ICL".}

\item{nbCore}{integer defining the number of processor to use (default is 1, 0 for all).}
}
\value{
An instance of the [\code{\linkS4class{KmmModel}}] class.
}
\description{
This function computes the optimal kernel mixture model (KMM) according
to the [\code{criterion}] among the number of clusters given in
[\code{nbCluster}], using the strategy specified in [\code{strategy}].
}
\note{
in KmmModel instance returned, the gram matrix is computed if and only
if kernelComputation is \code{TRUE}.
}
\examples{
## A quantitative example with the famous bulls eye model
data(bullsEye)
## estimate model
model <- kmm( data=bullsEye, nbCluster=2:3, models= "kmm_pk_s")


## get summary
summary(model)
## use graphics functions
\dontrun{
plot(model)
}

}
\author{
Serge Iovleff
}
