% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ClusterHeterogeneous.R
\name{clusterHeterogeneous}
\alias{clusterHeterogeneous}
\title{Create an instance of the [\code{\linkS4class{ClusterHeterogeneous}}] class}
\usage{
clusterHeterogeneous(data, modelNames, nbCluster = 2,
  strategy = clusterFastStrategy(), criterion = "ICL", nbCore = 1)
}
\arguments{
\item{data}{[\code{list}] containing the data sets (matrices and/or data.frames).
If the data sets contains NA values, they will be estimated during the
estimation process.}

\item{modelNames}{[\code{vector}] of character and of same length than data
containing the model names to fit to each data set.}

\item{nbCluster}{[\code{\link{vector}}] listing the number of clusters to test.}

\item{strategy}{a [\code{\linkS4class{ClusterStrategy}}] object containing
the strategy to run. clusterStrategy() method by default.}

\item{criterion}{character defining the criterion to select the best model.
The best model is the one with the lowest criterion value.
Possible values: "BIC", "AIC", "ICL". Default is "ICL".}

\item{nbCore}{integer defining the number of processors to use (default is 1, 0 for all).}
}
\value{
An instance of the [\code{\linkS4class{ClusterHeterogeneous}}] class.
}
\description{
This function computes the optimal heterogeneous mixture model according
to the \code{criterion} among the number of clusters given in
\code{nbCluster} using the strategy specified in [\code{strategy}].
}
\examples{
## A quantitative example with the heart disease data set
 data(HeartDisease.cat)
 data(HeartDisease.cont)
## with default values
ldata = list(HeartDisease.cat,HeartDisease.cont);
lnames = c("categorical_pk_pjk","gaussian_pk_sjk")
model <- clusterHeterogeneous(ldata, lnames, nbCluster=2:5, strategy = clusterFastStrategy())

## get summary
summary(model)

## print model
\dontrun{
print(model)
}
## get estimated missing values
missingValues(model)

## use graphics functions
\dontrun{
plot(model)
}
}
\author{
Serge Iovleff
}

