% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speedyseq_functions.R
\name{select_taxa}
\alias{select_taxa}
\alias{select_taxa,sample_data,character-method}
\alias{select_taxa,otu_table,character-method}
\alias{select_taxa,taxonomyTable,character-method}
\alias{select_taxa,XStringSet,character-method}
\alias{select_taxa,phylo,character-method}
\alias{select_taxa,phyloseq,character-method}
\title{Select a subset of taxa in a specified order where possible}
\usage{
select_taxa(x, taxa, reorder = TRUE)

\S4method{select_taxa}{sample_data,character}(x, taxa)

\S4method{select_taxa}{otu_table,character}(x, taxa, reorder = TRUE)

\S4method{select_taxa}{taxonomyTable,character}(x, taxa, reorder = TRUE)

\S4method{select_taxa}{XStringSet,character}(x, taxa, reorder = TRUE)

\S4method{select_taxa}{phylo,character}(x, taxa)

\S4method{select_taxa}{phyloseq,character}(x, taxa, reorder = TRUE)
}
\arguments{
\item{x}{A phyloseq object or phyloseq component object}

\item{taxa}{Character vector of taxa to select, in requested order}

\item{reorder}{Logical specifying whether to use the order in \code{taxa} (TRUE)
or keep the order in \code{taxa_names(x)} (FALSE)}
}
\description{
Select (a subset of) taxa; if \code{x} allows taxa to be reordered, then taxa are
given in the specified order.
}
\details{
This is a simple selector function that is like \code{prune_taxa(taxa, x)} when
\code{taxa} is a character vector but always gives the taxa in the order \code{taxa}
if possible (that is, except for phy_tree's and phyloseq objects that
contain phy_tree's).
}
\author{
Michael R. McLaren (orcid: \href{https://orcid.org/0000-0003-1575-473X}{0000-0003-1575-473X})
}
