% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{hill_pq}
\alias{hill_pq}
\title{Graphical representation of hill number 0, 1 and 2 across a factor}
\usage{
hill_pq(
  physeq,
  variable,
  color_fac = NA,
  letters = FALSE,
  add_points = FALSE,
  add_info = TRUE,
  one_plot = FALSE,
  correction_for_sample_size = TRUE
)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{variable}{(required): The variable to test. Must be present in
the \code{sam_data} slot of the physeq object.}

\item{color_fac}{(optional): The variable to color the barplot}

\item{letters}{(optional, default=FALSE): If set to TRUE, the plot
show letters based on p-values for comparison. Use the
\code{\link[multcompView]{multcompLetters}} function from the package
multcompLetters. BROKEN for the moment. Note that na values in The
variable param need to be removed (see examples) to use letters.}

\item{add_points}{(logical): add jitter point on boxplot}

\item{add_info}{(logical, default TRUE) Do we add a subtitle with
information about the number of samples per modality ?}

\item{one_plot}{(logical, default FALSE) If TRUE, return a unique
plot with the four plot inside using the patchwork package.
Note that if letters and one_plot are both TRUE, tuckey HSD results
are discarded from the unique plot. In that case, use one_plot = FALSE
to see the tuckey HSD results in the fourth plot of the resulting list.}

\item{correction_for_sample_size}{(logical, default TRUE) This function
use a sqrt of the read numbers in the linear model in order to
correct for uneven sampling depth.}
}
\value{
Either an unique ggplot2 object (if one_plot is TRUE) or
a list of 4 ggplot2 plot:
\itemize{
\item plot_Hill_0 : the boxplot of Hill number 0 (= species richness)
against the variable
\item plot_Hill_1 : the boxplot of Hill number 1 (= Shannon index)
against the variable
\item plot_Hill_2 : the boxplot of Hill number 2 (= Simpson index)
against the variable
\item plot_tuckey : plot the result of the Tuckey HSD test
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Note that this function use a sqrt of the read numbers in the linear
model in order to correct for uneven sampling depth.
}
\examples{

p <- hill_pq(data_fungi_mini, "Height")
p_h1 <- p[[1]] + theme(legend.position = "none")
p_h2 <- p[[2]] + theme(legend.position = "none")
p_h3 <- p[[3]] + theme(legend.position = "none")
multiplot(plotlist = list(p_h1, p_h2, p_h3, p[[4]]), cols = 4)

\donttest{
# Artificially modify data_fungi to force alpha-diversity effect
data_fungi_modif <- clean_pq(subset_samples_pq(data_fungi, !is.na(data_fungi@sam_data$Height)))
data_fungi_modif@otu_table[data_fungi_modif@sam_data$Height == "High", ] <-
  data_fungi_modif@otu_table[data_fungi_modif@sam_data$Height == "High", ] +
  sample(c(rep(0, ntaxa(data_fungi_modif) / 2), rep(100, ntaxa(data_fungi_modif) / 2)))
p2 <- hill_pq(data_fungi_modif, "Height", letters = TRUE)
}
}
\author{
Adrien Taudière
}
