% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellanous.R
\name{dist_bycol}
\alias{dist_bycol}
\title{Compute paired distances among matrix (e.g. otu_table)}
\usage{
dist_bycol(x, y, method = "bray", nperm = 99, ...)
}
\arguments{
\item{x}{(required) A first matrix.}

\item{y}{(required) A second matrix.}

\item{method}{(default: 'bray') the method to use internally in the vegdist
function.}

\item{nperm}{(default: 99) The number of permutations}

\item{...}{others argument for \code{vegan::vegdist} function}
}
\value{
A list of length two : (i) a vector of observed distance ($obs) and
(ii) a matrix of the distance after randomization ($null)
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\note{
the first column of the first matrix is compare to the first column of
the second matrix, the second column of the first matrix is compare to the
second column of the second matrix and so on.
}
\seealso{
\code{\link[vegan]{vegdist}}
}
\author{
Adrien Taudière
}
