% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{OVENdata}
\alias{OVENdata}
\title{Ovenbird light-level geolocator and GPS necessary data}
\format{
A named list with the necessary data to replicate the analyses
found in Cohen et al. (2018) with archival light-level geolocator and
GPS data.
The data contained in the list are:
\itemize{
  \item geo.bias: Archival light-level geolocator bias estimates.
       Location bias estimates in light-level geolocator estimates calculated
       using birds captured at known locations in Florida, Jamaica and Puerto Rico.
        Location bias is reported in meters and is a vector of length two with bias
        estimates in geolocator locations.
        Format: A vector of length two with bias estimates in geolocator locations.
  \item geo.vcov: Covariance estimates in light-level geolocator estimates calculated
        using birds captured at known locations in Florida, Jamaica, and Puerto Rico.
        Covariance is reported in meters.
        Format:  A 2x2 matrix of covariance estimates.
  \item isGL: Archival light-level geolocator or PinPoint-10 GPS tag
         \code{logical} vector indicating whether location estimates were obtained with a
         light-level geolocator (\code{TRUE}) or PinPoint-10 GPS tag (\code{FALSE}).
         Format:  \code{logical} of length 39
  \item targetPoints: Non-breeding locations for 39 Ovenbirds caught during the breeding
        season who carried either a light-level geolocator or PinPoint-10 GPS tag.
        Ovenbirds were captured at Hubbard Brook Experimental Forest, NH and Jug Bay Wetland
        Sanctuary, MD. These data are used as \code{originPoints} in the \code{estMC} function.
         \code{coords.x1} and \code{coords.x2} represent the longitude and latitude of the
         capture sites, respectively. The data are projected in Lambert Conformal Conic.
        Format:  \code{SpatialPoints}
        "+proj=aea +lat_1=20 +lat_2=60 +lat_0=40 +lon_0=-96 +x_0=0 +y_0=0 +ellps=GRS80
         +datum=NAD83 +units=m +no_defs +towgs84=0,0,0"
  \item originPoints: Capture locations for 39 Ovenbirds caught during the breeding season
        who carried either a light-level geolocator or PinPoint-10 GPS tag. Ovenbirds were
        captured at Hubbard Brook Experimental Forest, NH and Jug Bay Wetland Sanctuary, MD.
        These data are used as \code{originPoints} in the \code{estMC} function. \code{coords.x1}
        and \code{coords.x2} represent the longitude and latitude of the capture sites, respectively.
         The data are projected in Lambert Conformal Conic.
        Format:  \code{SpatialPoints}
  \item targetSites: Non-breeding distribution target sites used in Cohen et al. (in prep) to
        estimate MC of Ovenbirds tracked with light-level geolocators and PinPoint-10 GPS tags.
        There are three non-breeding target sites 1) Florida, United States, 2) Cuba, and 3) Hispaniola
        (Dominican Republic and Haiti).
        Format:  \code{SpatialPolygons}
  \item originSites: Breeding distribution origin sites used in Cohen et al. (in prep) to estimate
        MC of Ovenbirds tracked with light-level geolocators and PinPoint-10 GPS tags. There are two breeding
        origin sites, one that encompasses NH and another that encompasses MD capture deployment locations.
        Format: \code{SpatialPolygons}
  \item originRelAbund: A dataset containing relative abundance estimates from BBS data reported in Cohen et al.
       (in prep). These estimates can be used in \code{estMC} function as \code{originRelAbund} in conjunction
       with archival light-level geolocator and GPS locations.
       Format: A vector of length two with relative abundance estimates.
  \item originDist: The pairwise Great Circle Distance between the center of the polygons contained within
        \code{originSites}. See "Ovenbird breeding distribution origin sites" or \code{originSites}.
       Format: square distance matrix
  \item targetDist: The pairwise Great Circle Distance between the center of the polygons contained within
       \code{targetSites}. See "Ovenbird non-breeding distribution target sites" or \code{targetSites}.
       Format: square distance matrix
}
}
\usage{
OVENdata
}
\description{
Ovenbird data from Cohen et al. (2018) and Hallworth and Marra (2015).
}
\keyword{datasets}
