% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{pheno_barplots}
\alias{pheno_barplots}
\title{pheno_barplots}
\usage{
pheno_barplots(bin_phenotypes)
}
\arguments{
\item{bin_phenotypes}{phenotypes data.frame containing some of the following variables (with the same namenclature):
"sex","diabetes", "lipidmed",  "blood_pressure_lowering_med", "current_smoking",
"metabolic_syndrome", "alcohol_consumption", "age","BMI", "ln_hscrp","waist_circumference",
"weight","height", "triglycerides", "ldl_chol", "hdlchol", "totchol", "eGFR","wbc","hgb"}
}
\value{
The phenotypic variables binarized following the thresholds in in the metabolomics surrogates made by by Bizzarri et al.
}
\description{
#' Function created to binarize the phenotypes used to calculate the metabolomics based surrogate made by Bizzarri et al.
}
\details{
Bizzarri et al. built multivariate models,using 56 metabolic features quantified by Nightingale, to predict the 19 binary characteristics of an individual.
The binary variables are: sex, diabetes status, metabolic syndrome status, lipid medication usage, blood pressure lowering medication,
current smoking, alcohol consumption, high age, middle age, low age, high hsCRP, high triglycerides, high ldl cholesterol,
high total cholesterol, low hdl cholesterol, low eGFR, low white blood cells, low hemoglobin levels.
}
\examples{
require(MiMIR)
require(foreach)

#load the phenotypes dataset
phenotypes <- synthetic_phenotypic_dataset

#Calculate BMI, LDL cholesterol and eGFR
binarized_phenotypes<-binarize_all_pheno(phenotypes)
#Plot the variables
pheno_barplots(binarized_phenotypes)


}
\references{
This function was made to vidualize the binarized variables calculated following the rules indicated in the article:
Bizzarri,D. et al. (2022) 1H-NMR metabolomics-based surrogates to impute common clinical risk factors and endpoints. EBioMedicine, 75, 103764, \url{doi:10.1016/j.ebiom.2021.103764}
}
\seealso{
binarize_all_pheno
}
