% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{mape}
\alias{mape}
\title{Mean Absolute Percent Error}
\usage{
mape(actual, predicted)
}
\arguments{
\item{actual}{The ground truth numeric vector.}

\item{predicted}{The predicted numeric vector, where each element in the vector
is a prediction for the corresponding element in \code{actual}.}
}
\description{
\code{mape} computes the average absolute percent difference between two numeric vectors.
}
\details{
\code{mape} is calculated as the average of (\code{actual} - \code{predicted}) / \code{actual}.
This means that the function will return \code{-Inf}, \code{Inf}, or \code{NaN}
if \code{actual} is zero. Due to the instability at or near zero, \code{smape} or
\code{mase} are often used as alternatives.
}
\examples{
actual <- c(1.1, 1.9, 3.0, 4.4, 5.0, 5.6)
predicted <- c(0.9, 1.8, 2.5, 4.5, 5.0, 6.2)
mape(actual, predicted)
}
\seealso{
\code{\link{mae}} \code{\link{smape}} \code{\link{mase}}
}
