% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mse.R
\name{mse}
\alias{mse}
\title{Plot the mean squared errors}
\usage{
mse(object)
}
\arguments{
\item{object}{list returned by \link{measure_compare} function.}
}
\description{
This function draws the "MSE plot", which is used to compare the precision of
the two measurement methods without recalibrating the new method.
It is obtained by graphing the mean squared errors of \code{y1} (new method) and \code{y2} (reference
method) versus the BLUP of the latent trait, \code{x}, along with their 95\%
simultaneous confidence bands.
}
\examples{
\donttest{
### Load the data
data(data1)
### Analysis
measure_model <- measure_compare(data1, nb_simul=100)
### Plot the mean squared errors
mse(measure_model)}
}
