% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_functions.R
\name{get_parameterValues}
\alias{get_parameterValues}
\title{Get Default Parameter Values}
\usage{
get_parameterValues(rootData = NULL)
}
\arguments{
\item{rootData}{NULL to return default parameter values. For data parameter values, provide rootData as the output of simulate_initialData()$data.}
}
\value{
A data frame containing default parameter values.
}
\description{
This function retrieves parameter values for the DNA methylation simulation.
}
\details{
The function called without arguments returns default parameter values.
When rootData (as $data output of simulate_initialData()) is given, it returns data parameter values.
}
\examples{
# Get default parameter values
default_values <- get_parameterValues()

# Get parameter values of simulate_initialData() output
custom_params <- get_parameterValues()
infoStr <- data.frame(n = c(5, 10), globalState = c("M", "U"))
rootData <- simulate_initialData(infoStr = infoStr, params = custom_params)$data
rootData_paramValues <- get_parameterValues(rootData = rootData)

}
