% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setCypher.R
\name{connect}
\alias{connect}
\title{Connecting to NEO4J Graph Database.}
\usage{
connect(url = "127.0.0.1", port = 7474, username = "neo4j",
  password = "neo4j", test = TRUE)
}
\arguments{
\item{url}{url to running instance of neo4j}

\item{port}{port}

\item{username}{username}

\item{password}{password}

\item{test}{run test to show connection success or failure}
}
\description{
`connect` sets params such as the REST API URL, port, db username and password,
In the newer versions of neo4j default requires username and password. If this 
is the first time connecting to a new neo4jDB, please index the nodes else the queries
will be very slow.
}
\examples{
\dontrun{
connect(url="127.0.0.1", port=7474, username="neo4j", password="neo4j")

If this is your first time connecting to omics DB please index the nodes, using `index`
else query speed will be very slow.

Sending test query: Searching for K00001
#A successful connection will give the following
Connection Successful

Found these indices:
  property_keys   label
1        contig contigs
2           bin contigs
3           cpd     cpd
4            ko      ko
5         taxid   Taxon
}
}
