% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Metalonda.R
\name{metalondaAll}
\alias{metalondaAll}
\title{Metagenomic Longitudinal Differential Abundance Analysis for all Features}
\usage{
metalondaAll(Count, Time, Group, ID, n.perm = 500,
  fit.method = "nbinomial", num.intervals = 100, parall = FALSE,
  pvalue.threshold = 0.05, adjust.method = "BH", time.unit = "days",
  norm.method = "none", prefix = "Output",
  ylabel = "Normalized Count", col = c("blue", "firebrick"))
}
\arguments{
\item{Count}{Count matrix of all features}

\item{Time}{Time label of all samples}

\item{Group}{Group label of all samples}

\item{ID}{individual ID label for samples}

\item{n.perm}{number of permutations}

\item{fit.method}{The fitting method (nbinomial, lowess)}

\item{num.intervals}{The number of time intervals at which metalonda test differential abundance}

\item{parall}{logic to indicate whether to use multicore}

\item{pvalue.threshold}{p-value threshold cutoff}

\item{adjust.method}{Multiple testing correction methods}

\item{time.unit}{time unit used in the Time vector (hours, days, weeks, months, etc.)}

\item{norm.method}{normalization method to be used to normalize count matrix (css, tmm, ra, log10, median_ratio)}

\item{prefix}{prefix for the output figure}

\item{ylabel}{text to be shown on the y-axis of all generated figures (default: "Normalized Count")}

\item{col}{two color to be used for the two groups (eg., c("red", "blue")).}
}
\value{
Returns a list of the significant features a long with their significant time intervals
}
\description{
Identify significant features and their significant time interval
}
\examples{
\dontrun{
data(metalonda_test_data)
n.sample = 5
n.timepoints = 10
n.group = 2
Group = factor(c(rep(0, n.sample*n.timepoints), rep(1,n.sample*n.timepoints)))
Time = rep(rep(1:n.timepoints, times = n.sample), 2)
ID = factor(rep(1:(2*n.sample), each = n.timepoints))
points = seq(1, 10, length.out = 10)
output.nbinomial = metalondaAll(Count = metalonda_test_data, Time = Time, Group = Group,
ID = ID, n.perm = 10, fit.method =  "nbinomial", num.intervals = 100, 
parall = FALSE, pvalue.threshold = 0.05, adjust.method = "BH", 
time.unit = "hours", norm.method = "none", prefix = "Test",  time.unit = "hours", 
ylabel = "Normalized Count", col = c("black", "green"))
}
}
\references{
Ahmed Metwally (ametwall@stanford.edu)
}
