% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prcPlot.R
\name{prcPlot}
\alias{prcPlot}
\title{Plot the PRC Curve for a Dataset}
\usage{
prcPlot(filterObject, datasetObject, title = datasetObject$formattedName,
  subtitle = NULL, textSize = NULL, rounding = 3, curveColors = "red",
  legend = TRUE, PRC.lty = 1, PRC.lwd = 1, backgroundColor = "gray93",
  grid.marks = 0.1, grid.color = "white", grid.lty = 1, grid.lwd = 0.9,
  legend.lty = 0, cex.main = 1, cex.subtitle = 0.9)
}
\arguments{
\item{filterObject}{a metaFilter object containing the signature genes that will be used for calculating the score}

\item{datasetObject}{a Dataset object for group comparison in the PRC plot. (At least, must have a \code{$expr} of probe-level data, \code{$keys} of probe:gene mappings, and \code{$class} of two-class labels.)}

\item{title}{title of the plot (default: \code{datasetObject$formattedName})}

\item{subtitle}{subtitle of the figure}

\item{textSize}{use this to easily increase or decrease the size of all the text in the plot}

\item{rounding}{how many digits to round the AUPRC and CI to (default: 3)}

\item{curveColors}{\emph{Graphical:} the color for the PRC curves (default: "red")}

\item{legend}{\emph{Graphical:} if TRUE, a legend will be included}

\item{PRC.lty}{\emph{Graphical:} PRC curve line type}

\item{PRC.lwd}{\emph{Graphical:} PRC curve line width}

\item{backgroundColor}{\emph{Graphical:} background color of the plot}

\item{grid.marks}{\emph{Graphical:} increment between grid lines}

\item{grid.color}{\emph{Graphical:} grid line color}

\item{grid.lty}{\emph{Graphical:} grid line type}

\item{grid.lwd}{\emph{Graphical:} grid line width}

\item{legend.lty}{\emph{Graphical:} legend style (0 is no box, 1 is boxed legend)}

\item{cex.main}{\emph{Graphical:} title size}

\item{cex.subtitle}{\emph{Graphical:} subtitle size}
}
\value{
Returns a standard PRC plot, plus AUPRC with 95\% CI (calculated with the trapezoid method).
}
\description{
prcPlot will plot a Precision-Recall curve (and return the AUPRC) that describes how well a gene signature (as defined in a \code{filterObject}) classifies groups in a dataset (in the form of a \code{datasetObject}).
}
\details{
Evaluates the ability of a given gene set to separate two classes. As opposed to ROC curves, PRC curves are more sensitive to class imbalances.
The gene set is evaluated as a Z-score of the difference in means between the positive genes and the negative genes (see calculateScore).
}
\examples{
prcPlot(tinyMetaObject$filterResults[[1]], tinyMetaObject$originalData[[1]])
}
\seealso{
\code{\link{multiplePRCPlot}}, \code{\link{rocPlot}}
}
\author{
Aditya Rao & Jiaying Toh
}
