% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputeSex.R
\name{imputeSex}
\alias{imputeSex}
\title{Imputes biological sex of each sample in a Dataset object}
\usage{
imputeSex(myDataset, femGenes = NULL, malGenes = NULL)
}
\arguments{
\item{myDataset}{\code{datasetObject}}

\item{femGenes}{vector of gene symbols of genes higher expressed in females. Defaults to NULL}

\item{malGenes}{vector of gene symbols of genes higher expressed in males. Defaults to NULL}
}
\value{
a vector indicating whether each sample is classified as "male" or "female"
}
\description{
Imputes biological sex of each sample in a Dataset object
}
\details{
Imputes the sex of each sample in a Dataset object by performing K means
clustering. If genes higher expressed in females (femGenes) and genes higher
expressed in males (malGenes) are not supplied, then clutering
is performed on a default set of known X-escape genes (Tukiainen et al. 2017 Nature) 
and Y-chromosome genes. 
Genes were chosen as a subset of the immune Sex Expression Signature (iSEXS) (Bongen et al. In Prep.)

Known X-Escape genes: 
"XIST","RPS4X","CD40LG","ZRSR2","EFHC2","CA5B","ZFX","EIF1AX","CA5BP1","UBA1","SYAP1","DDX3X","FUNDC1","USP9X","SMC1A","NUP62CL","NAA10"

Y-Chromosome genes:
"KDM5D","RPS4Y1","EIF1AY","USP9Y","DDX3Y","UTY","PRKY","ZFY","TMSB4Y"
}
\examples{
# Add sex labels to your dataset of choice
\dontrun{
myDatasets = getGEOData(c("GSE13485","GSE17156","GSE19442"))
myDatasets$originalData$GSE13485$pheno$sex = imputeSex(myDatasets$originalData$GSE13485)
myDatasets$originalData$GSE13485$pheno$sex
}
}
\author{
Erika Bongen
}
