% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_edge_assignments.R
\name{merge_edge_assignments}
\alias{merge_edge_assignments}
\title{Merges two or more EDGE-like taxonomical assignments. The input data frames are assumed to
have the following columns: LEVEL, TAXA, and ABUNDANCE -- these will be used in the merge
procedure, all other columns will be ignored.}
\usage{
merge_edge_assignments(assignments)
}
\arguments{
\item{assignments}{A named list of assignments (the list element's name will be used as a
resulting data frame column name).}
}
\value{
A merged table, which is a data frame whose rows are taxonomical ids and columns are
         the input assignments ids.
}
\description{
Merges two or more EDGE-like taxonomical assignments. The input data frames are assumed to
have the following columns: LEVEL, TAXA, and ABUNDANCE -- these will be used in the merge
procedure, all other columns will be ignored.
}
\examples{
\dontrun{
hmp_even_fp <- system.file("extdata", "HMP_even", package="MetaComp")
hmp_stagger_fp <- system.file("extdata", "HMP_stagger", package="MetaComp")
data_files <- data.frame(V1 = c("HMP_even", "HMP_stagger"),
                         V2 = c(file.path(hmp_even_fp, "allReads-gottcha2-speDB-b.list.txt"),
                                file.path(hmp_stagger_fp, "allReads-gottcha2-speDB-b.list.txt")))
write.table(data_files, file.path(tempdir(), "assignments.txt"),
                                                 row.names = FALSE, col.names = FALSE)
gottcha2_assignments = merge_edge_assignments(
                         load_edge_assignments(
                           file.path(tempdir(), "assignments.txt"), type = "gottcha2"))
}

}
