% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_median-methods.R
\docType{methods}
\name{mr_median}
\alias{mr_median}
\alias{mr_median,MRInput-method}
\title{Median-based method}
\usage{
mr_median(object, weighting = "weighted", distribution = "normal",
  alpha = 0.05, iterations = 10000, seed = 314159265)

\S4method{mr_median}{MRInput}(object, weighting = "weighted",
  distribution = "normal", alpha = 0.05, iterations = 10000,
  seed = 314159265)
}
\arguments{
\item{object}{An \code{MRInput} object.}

\item{weighting}{The type of weighting applied. The default option is to calculate the weighted median (\code{"weighted"}); other options are \code{"simple"} and \code{"penalized"}.}

\item{distribution}{The type of distribution to use to calculate the 95\% confidence intervals, can be \code{"normal"} or \code{"t-dist"}.}

\item{alpha}{The significance level used to calculate the confidence intervals. The default value is 0.05.}

\item{iterations}{The number of bootstrap samples to generate when calculating the estimated standard error. The default value is 10000.}

\item{seed}{The random seed to use when generating the bootstrap samples (for reproducibility). The default value is 314159265. If set to \code{NA}, the random seed will not be set (for example, if the function is used as part of a larger simulation).}
}
\value{
The output from the function is a \code{WeightedMedian} object containing:

 \item{Type}{The type of weights used: \code{"weighted"}, \code{"simple"}, or \code{"penalized"}.}
 \item{Exposure}{A character string giving the name given to the exposure.}
 \item{Outcome}{A character string giving the name given to the outcome.}
 \item{Estimate}{The value of the causal estimate.}
 \item{StdError}{Standard error of the causal estimate calculated using bootstrapping.}
 \item{CILower}{The lower bound for the causal estimate based on the estimated bootstrapped standard error and the significance level provided.}
 \item{CIUpper}{The upper bound for the causal estimate based on the estimated bootstrapped standard error and the significance level provided.}
 \item{Alpha}{The significance level used when calculating the confidence intervals.}
 \item{Pvalue}{The p-value associated with the estimate (calculated using \code{Estimate/StdError} as per a Wald test) using a normal or t-distribution (as specified in \code{distribution}).}
 \item{SNPs}{The number of genetic variants (SNPs) included in the analysis.}
}
\description{
The \code{mr_median} function implements the weighted median (default) or simple median method introduced by Bowden et al (2016) to calculate
the median of the ratio instrumental variable estimates evaluated using each genetic variant individually.
}
\details{
The median-based methods have greater robustness to individual genetic variants with strongly outlying causal estimates
compared with the inverse-variance weighted and MR-Egger methods. Formally, the simple median method gives a
consistent estimate of the causal effect when at least 50\% of the genetic variants are valid instrumental variables
(for the weighted median method, when 50\% of the weight comes from valid instrumental variables).

When the weighting is \code{"simple"}, the estimate is obtained by calculating the ratio causal estimates
from each genetic variants theta = betaY/betaX, and finding the median estimate.

When the weighting is \code{"weighted"}, the estimate is obtained by:

\enumerate{
 \item Calculating the ratio causal estimates and ordering the genetic variants according to the magnitude of their estimates, i.e. \deqn{\theta_1 < \theta_2 < ... < \theta_J}{theta_1 < theta_2 < ... < theta_J}
 \item Calculate normalized inverse-variance weights for each genetic variant \eqn{w_1, w_2, ..., w_J}, as:
   \deqn{w_j = \frac{\beta_{Xj}^2}{se(\beta_{Yj})^2} / \sum_{i=1}^{J} \frac{\beta_{Xi}^2}{se(\beta_{Yi})^2}}{w_j = frac{betaX_j^2}{betaYse_j^2} / sum_i frac{betaX_i^2}{betaYse_l^2}}
 \item Find k such that
   \deqn{s_k = \sum_{i = 1}^k w_i < 0.5}{s_k = w_1 + w_2 + ... + w_k < 0.5}
   and
   \deqn{s_{k+1}  = \sum_{i = 1}^{k+1} w_i > 0.5}{s_(k+1) = w_1 + w_2 +... + w_k + w_(k+1) > 0.5}
 \item Calculate the weighted median estimate by extrapolation as:
   \deqn{\theta_{WM} = \theta_k + (\theta_{k+1} - \theta_k) \times \frac{0.5 - s_k}{s_{k+1} - s_k}}{theta_(WM) = theta_k + (theta_(k+1) - theta_k) * frac{0.5 - s_k}{s_(k+1) - s_k}} }

The simple median estimate is the same as the weighted median estimate when all the weights are equal. Standard errors
for both the simple and weighted median methods are calculated through bootstrapping.

When the weighting is \code{"penalized"}, the weighted method is used, but the contribution of genetic variants with outlying (heterogeneous) ratio estimates to the analysis is downweighted.
}
\examples{
mr_median(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse),
  weighting = "weighted", iterations = 100)
  # iterations is set to 100 to reduce runtime for the mr_median method,
  # 10000 iterations are recommended in practice
mr_median(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse),
  weighting = "simple", iterations = 100)
mr_median(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse),
  weighting = "penalized", iterations = 100)

}
\references{
Jack Bowden, George Davey Smith, Philip C Haycock, Stephen Burgess. Consistent estimation in Mendelian randomization with
some invalid instruments using a weighted median estimator. Genetic Epidemiology 2016; 40(4):304-314. doi: 10.1002/gepi.21965.
}
