% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHUCName.R
\name{getHUCName}
\alias{getHUCName}
\title{Return HUC names at specified locations}
\usage{
getHUCName(
  longitude = NULL,
  latitude = NULL,
  dataset = NULL,
  HUCs = NULL,
  allData = FALSE,
  useBuffering = FALSE
)
}
\arguments{
\item{longitude}{Vector of longitudes in decimal degrees East.}

\item{latitude}{Vector of latitudes in decimal degrees North.}

\item{dataset}{Name of spatial dataset to use.}

\item{HUCs}{Vector of Hydrologic Unit Codes used to limit searches.}

\item{allData}{Logical specifying whether a full dataframe should be returned}

\item{useBuffering}{Logical flag specifying the use of location buffering to
find the nearest polygon if no target polygon is found.}
}
\value{
Vector of HUC names.
}
\description{
Uses spatial comparison to determine which HUC polygons the
locations fall into and returns the HUC names for those polygons.

Specification of \code{HUCs} limits spatial searching to the
specified HUCs and greatly improves performance. For instance, if searching
for level 10 HUCs in the Upper Columbia basin, it would make sense to first
search WBDHU4_01 to learn that the level 4 HUC is \code{1702}. Then you
can greatly improve search times for higher level HUCs by specifying:
\code{HUCs = c("1702")}.

If \code{allData = TRUE}, additional data is returned.
}
\seealso{
getSpatialData
}
\keyword{locator}
