% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadSpatialData.R
\name{loadSpatialData}
\alias{loadSpatialData}
\title{Load spatial datasets}
\usage{
loadSpatialData(pattern = "*")
}
\arguments{
\item{pattern}{regular expression used to match filenames}
}
\value{
Invisibly returns a vector of spatial dataset names loaded into the 
global environment.
}
\description{
Load datasets found in the directory previously set with 
\code{setSpatialDataDir()}. 
Only files matching \code{pattern} will be loaded.

Core datastes available for the package include:
\itemize{
\item{\code{TMWorldBorders} -- high resolution country polygons (higher 
resolution than \code{SimpleCountries})}
\item{\code{NaturalEarthAdm1} -- state/province polygons throughout the world}
\item{\code{USCensusCounties} -- county polygons in the United States}
\item{\code{WorldTimezones} -- high resolution timezone polygons (higher 
resolution than \code{SimpleTimezones})}
}

These can be installed with \code{installSpatialData()}.
}
\seealso{
setSpatialDataDir

installSpatialData
}
\keyword{environment}
