% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeRange.R
\name{timeRange}
\alias{timeRange}
\title{Create a POSIXct time range}
\usage{
timeRange(starttime = NULL, endtime = NULL, timezone = NULL)
}
\arguments{
\item{starttime}{Desired start datetime (ISO 8601).}

\item{endtime}{Desired end datetime (ISO 8601).}

\item{timezone}{Olson timezone used to interpret dates.}
}
\value{
A vector of two \code{POSIXct}s.
}
\description{
Uses incoming parameters to return a pair of \code{POSIXct} times in the
proper order.

The required \code{timezone} parameter must be one of those found in
\code{\link[base]{OlsonNames}}.

Dates can be anything that is understood by
\code{lubrdiate::parse_date_time()} including either of the following
recommended formats:

\itemize{
  \item{\code{"YYYYmmddHH[MMSS]"}}
  \item{\code{"YYYY-mm-dd HH:MM:SS"}}
}
}
\section{POSIXct inputs}{

When \code{startdate} or \code{enddate} are already \code{POSIXct} values,
they are converted to the timezone specified by \code{timezone} without
altering the physical instant in time the input represents. This is different
from the behavior of \code{\link[lubridate]{parse_date_time}} (which powers
this function), which will force \code{POSIXct} inputs into a new timezone,
altering the physical moment of time the input represents.
}

\examples{
timeRange("2019-01-08 10:12:15", 20190109102030, timezone = "UTC")
}
