% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{show}
\alias{show}
\alias{show,sparseMatrix-method}
\alias{show,sparseVector-method}
\alias{print,sparseVector-method}
\title{Quick Glance at Sparse Objects}
\usage{
\S4method{show}{sparseMatrix}(object)

\S4method{show}{sparseVector}(object)

\S4method{print}{sparseVector}(x)
}
\arguments{
\item{object}{A sparse matrix or sparse vector.}

\item{x}{A sparse vector (same method as in matrix, readded here to avoid naming conflicts).}
}
\value{
The same object that was passed as input, as invisible.
}
\description{
Shows some basic information about a sparse matrix or sparse vector object,
without printing a subset of its entries as `Matrix` would do.

Note that this package will by default override the `show` methods of sparse objects, but not
the `print` methods - for example, if one defines a variable 'X' containing a sparse matrix, and
then types 'X' in the console, that calls the `show` method, but one can still print it by calling
'print(X)'.

In order to restore the `show` method provided by `Matrix`, call `options("MatrixExtra.quick_show" = FALSE)`.
}
\examples{
library(Matrix)
library(MatrixExtra)

set.seed(1)
X <- Matrix::rsparsematrix(5, 5, .2)
set_new_matrix_behavior()
show(X)
print(X)
X

restore_old_matrix_behavior()
show(X)
print(X)
X
}
