% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Matrix.utils.R
\name{aggregate.Matrix}
\alias{aggregate.Matrix}
\title{Compute summary statistics of a Matrix}
\usage{
\method{aggregate}{Matrix}(x, groupings = NULL, form = NULL, fun = "sum",
  ...)
}
\arguments{
\item{x}{a \code{\link{Matrix}} or matrix-like object}

\item{groupings}{an object coercible to a group of factors defining the
groups}

\item{form}{\code{\link[stats]{formula}}}

\item{fun}{character string specifying the name of aggregation function to be
applied to all columns in data.  Currently "sum", "count", and "mean"
are supported.}

\item{...}{arguments to be passed to or from methods.  Currently ignored}
}
\value{
A sparse \code{Matrix}.  The rownames correspond to the values of the
  groupings or the interactions of groupings joined by a \code{_}.
  
  There is an attribute \code{crosswalk} that includes the groupings as a
  data frame.  This is necessary because it is not possible to include
  character or data frame groupings in a sparse Matrix.  If needed, one can 
  \code{cbind(attr(x,"crosswalk"),x)} to combine the groupings and the
  aggregates.
}
\description{
Similar to \code{\link[stats]{aggregate}}.  Splits the matrix into groups as 
specified by groupings, which can be one or more variables. Aggregation 
function will be applied to all columns in data, or as specified in formula. 
Warning: groupings will be made dense if it is sparse, though data will not.
}
\details{
\code{aggregate.Matrix} uses its own implementations of functions and should
be passed a string in the \code{fun} argument.
}
\examples{
skus<-Matrix(as.matrix(data.frame(
   orderNum=sample(1000,10000,TRUE),
   sku=sample(1000,10000,TRUE),
   amount=runif(10000))),sparse=TRUE)
#Calculate sums for each sku
a<-aggregate.Matrix(skus[,'amount'],skus[,'sku',drop=FALSE],fun='sum')
#Calculate counts for each sku
b<-aggregate.Matrix(skus[,'amount'],skus[,'sku',drop=FALSE],fun='count')
#Calculate mean for each sku
c<-aggregate.Matrix(skus[,'amount'],skus[,'sku',drop=FALSE],fun='mean')

m<-rsparsematrix(1000000,100,.001)
labels<-as.factor(sample(1e4,1e6,TRUE))
b<-aggregate.Matrix(m,labels)

\dontrun{
orders<-data.frame(orderNum=as.factor(sample(1e6, 1e7, TRUE)),
   sku=as.factor(sample(1e3, 1e7, TRUE)),
   customer=as.factor(sample(1e4,1e7,TRUE)),
   state = sample(letters, 1e7, TRUE), amount=runif(1e7))
system.time(d<-aggregate.Matrix(orders[,'amount',drop=FALSE],orders$orderNum))
system.time(e<-aggregate.Matrix(orders[,'amount',drop=FALSE],orders[,c('customer','state')]))
}
}
\seealso{
\code{\link[dplyr]{summarise}}

\code{\link[plyr]{summarise}}

\code{\link[stats]{aggregate}}
}
