% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.R
\name{is.mimipo}
\alias{is.mimipo}
\title{Checks for the \code{mimipo} Class}
\usage{
is.mimipo(object)
}
\arguments{
\item{object}{This argument specifies the object that should be checked to see if is of the \code{mimipo} class or not.}
}
\value{
This function returns a logical value indicating whether \code{object} is of the \code{mimipo} class.
}
\description{
\code{is.mimipo()} function checks whether class of objects is \code{mimipo} or not.
}
\details{
The class of objects is checked to be of the \code{mimipo}.
}
\examples{
\donttest{#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice(osteoarthritis, m = 5, maxit = 10,
                         method = c("", "", "mean", "polyreg",
                                    "logreg", "logreg", "logreg"))

#Estimating weights of observations in the multiply imputed datasets
weighted.datasets <- weightthem(OSP ~ AGE + SEX + BMI + RAC + SMK, imputed.datasets,
                                approach = 'within', method = 'nearest')

#Analyzing the matched datasets
models <- with(data = matched.datasets,
               exp = glm(KOA ~ OSP, family = binomial))

#Pooling results obtained from analysing the datasets
results <- pool(models)

#Checking the 'results' object
is.mimipo(results)
is(results)}
}
\seealso{
\code{\link[=pool]{pool}}

\code{\link[=mimipo]{mimipo}}
}
\author{
Farhad Pishgar
}
