% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ManifoldOptim-package.R
\name{Design of C++ code}
\alias{Design of C++ code}
\title{Overview of important files.}
\description{
Internal design of the ManifoldOptim portion of the embedded C++ code.
Most ManifoldOptim users should not need this.
ROPTLIB source code is also included in this package, but is not described here;
see Huang et al (2016a) for documentation on that portion of the code.
}
\details{
\describe{
\item{\code{src/ManifoldOptim/BrockettProblem.cpp}:}{
The Brockett problem, written as a module that can be invoked from within
the ManifoldOptim package. This serves as an example for package authors
who wish to expose modules to their users. Code to invoke this example from
outside of the ManifoldOptim package is provided in 
\code{inst/examples/brockett/cpp_pkg}.
}

\item{\code{src/ManifoldOptim/ManifoldOptim.cpp}:}{
Contains the main function \code{ManifoldOptim} which takes a problem
constructed in R, sets it up in ROPTLIB, runs it, and returns the result.
}

\item{\code{src/ManifoldOptim/ManifoldOptimModule.cpp}:}{
Defines an Rcpp module for ManifoldOptim which exposes C++ classes such as
\code{RProblem}. This module provides the most common means in which R users
will interact with ManifoldOptim.
}

\item{\code{src/ManifoldOptim/ManifoldFactory.h}:}{
The \code{GetManifold} function constructs a Manifold object based on its
name and dimensions. Manifold classes are defined in ROPTLIB.
}

\item{\code{src/ManifoldOptim/ProblemAdapter.h}:}{
Defines the \code{ProblemAdapter} class, which takes a
\code{ManifoldOptimProblem}, which is defined in the ManifoldOptim
API, and plugs it into the ROPTLIB API as an ROPTLIB \code{Problem}
subclass.
}

\item{\code{src/ManifoldOptim/RProblem.h}:}{
Defines the \code{RProblem} class, which allows the objective, gradient,
and Hessian functions to be defined in R. When a function in the ROPTLIB
library invokes the objective, gradient, or Hessian, this class invokes
the appropriate function in R.
}

\item{\code{src/ManifoldOptim/SolverFactory.h}:}{
The \code{GetSolver} function constructs a Solver object based on its name,
a given \code{Problem}, an initial value, and an initial Hessian. Solver
classes are defined in ROPTLIB.
}

\item{\code{src/ManifoldOptim/Util.h}:}{
Defines a few utility functions, especially to assist in translating between
the ManifoldOptim C++ API and the ROPTLIB API.
}

\item{\code{src/ManifoldOptim/VariableFactory.h}:}{
The \code{GetVariable} function returns an optimization variable suitable
for a given Manifold, based on its name and dimension. Optimization
variables for supported Manifolds are defined in ROPTLIB.
}

\item{\code{inst/include/ManifoldOptimException.h}:}{
Defines \code{ManifoldOptimException}, which is a subclass of STL
\code{exception}.
}

\item{\code{inst/include/ManifoldOptim.h}:}{
For users of the ManifoldOptim C++ API, this is the main header file to
include. For an example, see \code{inst/examples/brockett/cpp_sourceCpp/}.
}

\item{\code{inst/include/ManifoldOptimProblem.h}:}{
Defines \code{ManifoldOptimProblem}, which is the base class
for all optimization problems in the ManifoldOptim API. This class
facilitates writing problems with Armadillo, which can be
instantiated and manipulated in R, and solved through ROPTLIB.
This class assumes only that the optimization variable is a
one-dimensional vector; the user must reshape it into the appropriate
form (e.g. a matrix or list of matrices) when evaluating the objective,
gradient, and Hessian functions.
}
}
}
\references{
Wen Huang, P.A. Absil, K.A. Gallivan, Paul Hand (2016a). "ROPTLIB: an
object-oriented C++ library for optimization on Riemannian manifolds."
Technical Report FSU16-14, Florida State University.

Conrad Sanderson and Ryan Curtin. Armadillo: a template-based C++ library
for linear algebra. Journal of Open Source Software, Vol. 1, pp. 26, 2016.
}

