% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradients-likelihoods.R
\name{gr_sum_logL_GP_clust}
\alias{gr_sum_logL_GP_clust}
\title{Gradient of the mixture of Gaussian likelihoods}
\usage{
gr_sum_logL_GP_clust(hp, db, mixture, mean, kern, post_cov, pen_diag)
}
\arguments{
\item{hp}{A tibble, data frame or named vector of hyper-parameters.}

\item{db}{A tibble containing data we want to evaluate the logL on.
Required columns: Input, Output. Additional covariate columns are allowed.}

\item{mixture}{A tibble or data frame, indicating the mixture probabilities
of each cluster for the new individual/task.}

\item{mean}{A list of hyper-posterior mean parameters for all clusters.}

\item{kern}{A kernel function.}

\item{post_cov}{A list of hyper-posterior covariance parameters for all
clusters.}

\item{pen_diag}{A jitter term that is added to the covariance matrix to avoid
numerical issues when inverting, in cases of nearly singular matrices.}
}
\value{
A named vector, corresponding to the value of the hyper-parameters'
gradients for the mixture of Gaussian log-likelihoods involved in the
prediction step of MagmaClust.
}
\description{
Compute the gradient of a sum of Gaussian log-likelihoods, weighted by their
mixture probabilities.
}
\examples{
TRUE
}
\keyword{internal}
