% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFrame.R
\name{ModelFrame}
\alias{ModelFrame}
\alias{ModelFrame.formula}
\alias{ModelFrame.matrix}
\title{ModelFrame Class}
\usage{
ModelFrame(...)

\method{ModelFrame}{formula}(
  formula,
  data,
  groups = NULL,
  strata = NULL,
  weights = NULL,
  na.rm = TRUE,
  ...
)

\method{ModelFrame}{matrix}(
  x,
  y = NULL,
  offsets = NULL,
  groups = NULL,
  strata = NULL,
  weights = NULL,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{...}{arguments passed from the generic function to its methods.  The
first argument of each \code{ModelFrame} method is positional and, as such,
must be given first in calls to them.}

\item{formula, data}{\link[=formula]{formula} defining the model predictor and
response variables and a \link[=data.frame]{data frame} containing them.
In the associated method, arguments \code{groups}, \code{strata}, and
\code{weights} will be evaluated as expressions, whose objects are searched
for first in the accompanying \code{data} environment and, if not found
there, next in the calling environment.}

\item{groups}{vector of values defining groupings of case observations, such
as repeated measurements, to keep together during resampling [default:
none].}

\item{strata}{vector of values to use in conducting stratified
\link{resample} estimation of model performance [default: none].}

\item{weights}{numeric vector of non-negative case weights for the \code{y}
response variable [default: equal weights].}

\item{na.rm}{character string or logical specifying removal of \code{"all"}
(\code{TRUE}) cases with missing values, \code{"none"} (\code{FALSE}), or
only those whose missing values are in the \code{"response"} variable.}

\item{x, y}{\link{matrix} and object containing predictor and response
variables.}

\item{offsets}{numeric vector, matrix, or data frame of values to be added
with a fixed coefficient of 1 to linear predictors in compatible regression
models.}
}
\value{
\code{ModelFrame} class object that inherits from \code{data.frame}.
}
\description{
Class for storing data, formulas, and other attributes for \pkg{MachineShop}
model fitting.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

mf <- ModelFrame(ncases / (ncases + ncontrols) ~ agegp + tobgp + alcgp,
                 data = esoph, weights = ncases + ncontrols)
gbm_fit <- fit(mf, model = GBMModel)
varimp(gbm_fit)
}

}
\seealso{
\code{\link{fit}}, \code{\link{resample}}, \code{\link{response}},
\code{\link{SelectedInput}}
}
