% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfe.R
\name{rfe}
\alias{rfe}
\alias{rfe.formula}
\alias{rfe.matrix}
\alias{rfe.ModelFrame}
\alias{rfe.recipe}
\alias{rfe.ModelSpecification}
\alias{rfe.MLModel}
\alias{rfe.MLModelFunction}
\title{Recursive Feature Elimination}
\usage{
rfe(...)

\method{rfe}{formula}(formula, data, model, ...)

\method{rfe}{matrix}(x, y, model, ...)

\method{rfe}{ModelFrame}(input, model = NULL, ...)

\method{rfe}{recipe}(input, model = NULL, ...)

\method{rfe}{ModelSpecification}(
  object,
  select = NULL,
  control = MachineShop::settings("control"),
  props = 4,
  sizes = integer(),
  random = FALSE,
  recompute = TRUE,
  optimize = c("global", "local"),
  samples = c(rfe = 1, varimp = 1),
  metrics = NULL,
  stat = c(resample = MachineShop::settings("stat.Resample"), permute =
    MachineShop::settings("stat.TrainingParams")),
  progress = FALSE,
  ...
)

\method{rfe}{MLModel}(model, ...)

\method{rfe}{MLModelFunction}(model, ...)
}
\arguments{
\item{...}{arguments passed from the \code{MLModel} and
\code{MLModelFunction} methods to others and from the others to
\code{ModelSpecification}.  The first argument of each \code{rfe}
method is positional and, as such, must be given first in calls to them.}

\item{formula, data}{\link[=formula]{formula} defining the model predictor and
response variables and a \link[=data.frame]{data frame} containing them.}

\item{model}{\link[=models]{model} function, function name, or object; or
another object that can be \link[=as.MLModel]{coerced} to a model.  A model
can be given first followed by any of the variable specifications, and the
argument can be omitted altogether in the case of
\link[=ModeledInput]{modeled inputs}.}

\item{x, y}{\link{matrix} and object containing predictor and response
variables.}

\item{input}{\link[=inputs]{input} object defining and containing the model
predictor and response variables.}

\item{object}{model \link[=inputs]{input} or
\link[=ModelSpecification]{specification}.}

\item{select}{expression indicating predictor variables that can be
eliminated (see \code{\link[base]{subset}} for syntax) [default: all].}

\item{control}{\link[=controls]{control} function, function name, or object
defining the resampling method to be employed.}

\item{props}{numeric vector of the proportions of most important predictor
variables to retain in fitted models or an integer number of equal spaced
proportions to generate automatically; ignored if \code{sizes} are given.}

\item{sizes}{integer vector of the set sizes of most important predictor
variables to retain.}

\item{random}{logical indicating whether to eliminate variables at random
with probabilities proportional to their importance.}

\item{recompute}{logical indicating whether to recompute variable importance
after eliminating each set of variables.}

\item{optimize}{character string specifying a search through all \code{props}
to identify the globally optimal model (\code{"global"}) or a search that
stops after identifying the first locally optimal model (\code{"local"}).}

\item{samples}{numeric vector or list giving the number of permutation
samples for each of the \code{rfe} and \code{\link{varimp}} algorithms.
One or both of the values may be specified as named arguments or in the
order in which their defaults appear.  Larger numbers of samples decrease
variability in estimated model performances and variable importances at the
expense of increased computation time.  Samples are more expensive
computationally for \code{rfe} than for \code{varimp}.}

\item{metrics}{\link[=metrics]{metric} function, function name, or vector of
these with which to calculate performance.  If not specified, default
metrics defined in the \link{performance} functions are used.}

\item{stat}{functions or character strings naming functions to compute
summary statistics on resampled metric values and permuted samples.  One or
both of the values may be specified as named arguments or in the order in
which their defaults appear.}

\item{progress}{logical indicating whether to display iterative progress
during elimination.}
}
\value{
\code{TrainingStep} class object containing a summary of the numbers
of predictor variables retained (size), their names (terms), logical
indicators for the optimal model selected (selected), and associated
performance metrics (metrics).
}
\description{
A wrapper method of backward feature selection in which a given model is fit
to nested subsets of most important predictor variables in order to select
the subset whose resampled predictive performance is optimal.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

(res <- rfe(sale_amount ~ ., data = ICHomes, model = GBMModel))
summary(res)
summary(performance(res))
plot(res, type = "line")
}

}
\seealso{
\code{\link{performance}}, \code{\link{plot}},
\code{\link{summary}}, \code{\link{varimp}}
}
