% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{calibration}
\alias{calibration}
\title{Model Calibration}
\usage{
calibration(
  x,
  y = NULL,
  weights = NULL,
  breaks = 10,
  span = 0.75,
  distr = NULL,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{x}{\link[=response]{observed responses} or \link{resample} result
containing observed and predicted responses.}

\item{y}{\link[=predict]{predicted responses} if not contained in \code{x}.}

\item{weights}{numeric vector of non-negative
\link[=case_weights]{case weights} for the observed \code{x} responses
[default: equal weights].}

\item{breaks}{value defining the response variable bins within which to
calculate observed mean values.  May be specified as a number of bins, a
vector of breakpoints, or \code{NULL} to fit smooth curves with splines for
predicted survival probabilities and with \link[stats:loess]{loess} for
others.}

\item{span}{numeric parameter controlling the degree of loess smoothing.}

\item{distr}{character string specifying a distribution with which to
estimate the observed survival mean.  Possible values are
\code{"empirical"} for the Kaplan-Meier estimator, \code{"exponential"},
\code{"extreme"}, \code{"gaussian"}, \code{"loggaussian"},
\code{"logistic"}, \code{"loglogistic"}, \code{"lognormal"},
\code{"rayleigh"}, \code{"t"}, or \code{"weibull"}.  Defaults to the
distribution that was used in predicting mean survival times.}

\item{na.rm}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating metrics.}

\item{...}{arguments passed to other methods.}
}
\value{
\code{Calibration} class object that inherits from \code{data.frame}.
}
\description{
Calculate calibration estimates from observed and predicted responses.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

library(survival)

control <- CVControl() \%>\% set_predict(times = c(90, 180, 360))
res <- resample(Surv(time, status) ~ ., data = veteran, model = GBMModel,
                control = control)
cal <- calibration(res)
plot(cal)
}

}
\seealso{
\code{\link{c}}, \code{\link{plot}}
}
