% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand_modelgrid}
\alias{expand_modelgrid}
\alias{expand_modelgrid.formula}
\alias{expand_modelgrid.matrix}
\alias{expand_modelgrid.ModelFrame}
\alias{expand_modelgrid.recipe}
\alias{expand_modelgrid.TunedModel}
\title{Model Tuning Grid Expansion}
\usage{
expand_modelgrid(x, ...)

\method{expand_modelgrid}{formula}(x, data, model, info = FALSE, ...)

\method{expand_modelgrid}{matrix}(x, y, model, info = FALSE, ...)

\method{expand_modelgrid}{ModelFrame}(x, model, info = FALSE, ...)

\method{expand_modelgrid}{recipe}(x, model, info = FALSE, ...)

\method{expand_modelgrid}{TunedModel}(x, ..., info = FALSE)
}
\arguments{
\item{x}{\link[=inputs]{input} specifying a relationship between model
predictor and response variables.  Alternatively, a
\code{\link{TunedModel}} object may be given first followed optionally by
an input specification.}

\item{...}{arguments passed to other methods.}

\item{data}{\link[=data.frame]{data frame} containing observed predictors and
outcomes.}

\item{model}{\code{\link{TunedModel}} object.}

\item{info}{logical indicating whether to return model-defined grid
construction information rather than the grid values.}

\item{y}{response variable.}
}
\value{
A data frame of parameter values or \code{NULL} if data are required
for construction of the grid but not supplied.
}
\description{
Expand a model grid of tuning parameter values.
}
\details{
The \code{expand_modelgrid} function enables manual extraction and viewing of
grids created automatically when a \code{\link{TunedModel}} is fit.
}
\examples{
expand_modelgrid(TunedModel(GBMModel, grid = 5))

expand_modelgrid(TunedModel(GLMNetModel, grid = c(alpha = 5, lambda = 10)),
                 sale_amount ~ ., data = ICHomes)

gbm_grid <- ParameterGrid(
  n.trees = dials::trees(),
  interaction.depth = dials::tree_depth(),
  size = 5
)
expand_modelgrid(TunedModel(GBMModel, grid = gbm_grid))

rf_grid <- ParameterGrid(
  mtry = dials::mtry(),
  nodesize = dials::max_nodes(),
  size = c(3, 5)
)
expand_modelgrid(TunedModel(RandomForestModel, grid = rf_grid),
                 sale_amount ~ ., data = ICHomes)

}
\seealso{
\code{\link{TunedModel}}
}
