% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_FDAModel.R
\name{FDAModel}
\alias{FDAModel}
\alias{PDAModel}
\title{Flexible and Penalized Discriminant Analysis Models}
\usage{
FDAModel(
  theta = NULL,
  dimension = NULL,
  eps = .Machine$double.eps,
  method = .(mda::polyreg),
  ...
)

PDAModel(lambda = 1, df = NULL, ...)
}
\arguments{
\item{theta}{optional matrix of class scores, typically with number of
columns less than one minus the number of classes.}

\item{dimension}{dimension of the discriminant subspace, less than the number
of classes, to use for prediction.}

\item{eps}{numeric threshold for small singular values for excluding
discriminant variables.}

\item{method}{regression function used in optimal scaling.  The default of
linear regression is provided by \code{\link[mda]{polyreg}} from the
\pkg{mda} package.  For penalized discriminant analysis,
\code{\link[mda]{gen.ridge}} is appropriate.  Other possibilities are
\code{\link[mda]{mars}} for multivariate adaptive regression splines and
\code{\link[mda]{bruto}} for adaptive backfitting of additive splines.  Use
the \code{\link[MachineShop:dot-]{.}} operator to quote specified
functions.}

\item{...}{additional arguments to \code{method} for \code{FDAModel} and to
\code{FDAModel} for \code{PDAModel}.}

\item{lambda}{shrinkage penalty coefficient.}

\item{df}{alternative specification of \code{lambda} in terms of equivalent
degrees of freedom.}
}
\value{
\code{MLModel} class object.
}
\description{
Performs flexible discriminant analysis.
}
\details{
\describe{
  \item{Response Types:}{\code{factor}}
  \item{\link[=TunedModel]{Automatic Tuning} of Grid Parameters}{
    \itemize{
      \item FDAModel: \code{nprune}, \code{degree}*
      \item PDAModel: \code{lambda}
    }
  }
}
* included only in randomly sampled grid points

The \code{\link{predict}} function for this model additionally accepts the
following argument.
\describe{
  \item{\code{prior}}{prior class membership probabilities for prediction
    data if different from the training set.}
}

Default values for the \code{NULL} arguments and further model details can be
found in the source links below.
}
\examples{
fit(Species ~ ., data = iris, model = FDAModel)

fit(Species ~ ., data = iris, model = PDAModel)

}
\seealso{
\code{\link[mda]{fda}}, \code{\link[mda]{predict.fda}},
\code{\link{fit}}, \code{\link{resample}}
}
