% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand_params}
\alias{expand_params}
\title{Model Parameters Expansion}
\usage{
expand_params(...)
}
\arguments{
\item{...}{named vectors or factors or a list of these containing the
parameter values over which to create the grid.}
}
\value{
A data frame containing one row for each combination of the supplied
inputs.
}
\description{
Create a grid of parameter values from all combinations of supplied inputs.
}
\examples{
library(MASS)

grid <- expand_params(
  n.trees = c(50, 100),
  interaction.depth = 1:2
)

fit(medv ~ ., data = Boston, model = TunedModel(GBMModel, grid = grid))

}
\seealso{
\code{\link{tune}}, \code{\link{TunedModel}}
}
