% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependence.R
\name{dependence}
\alias{dependence}
\title{Partial Dependence}
\usage{
dependence(object, data = NULL, select = NULL, interaction = FALSE,
  n = 10, intervals = c("uniform", "quantile"),
  stats = MachineShop::settings("stats.PartialDependence"))
}
\arguments{
\item{object}{model \link{fit} result.}

\item{data}{\link[=data.frame]{data frame} containing all predictor
variables.  If not specified, the training data will be used by default.}

\item{select}{expression indicating predictor variables for which to compute
partial dependence (see \code{\link[base]{subset}} for syntax)
[default: all].}

\item{interaction}{logical indicating whether to calculate dependence on the
interacted predictors.}

\item{n}{number of predictor values at which to perform calculations.}

\item{intervals}{character string specifying whether the \code{n} values are
spaced uniformly (\code{"uniform"}) or according to variable quantiles
(\code{"quantile"}).}

\item{stats}{function, function name, or vector of these with which to
compute response variable summary statistics over non-selected predictor
variables.}
}
\value{
\code{PartialDependence} class object that inherits from
\code{data.frame}.
}
\description{
Calculate partial dependence of a response on select predictor variables.
}
\examples{
gbm_fit <- fit(Species ~ ., data = iris, model = GBMModel)
(pd <- dependence(gbm_fit, select = c(Petal.Length, Petal.Width)))
plot(pd)

}
\seealso{
\code{\link{plot}}
}
