univariateScore.temporal = function(target, reps, group, dataset, test, wei, dataInfo, targetID, slopes, ncores)
{
  univariateModels <- list();
  dm <- dim(dataset)
  rows <- dm[1]
  cols <- dm[2]
  if (targetID != -1 ) {
    target <- dataset[, targetID]
    dataset[, targetID] <- rnorm(rows)
  }
  
  la <- length( unique(target) )
  ina <- NULL
  if ( la == 2 )  ina <- target
  id <- Rfast::check_data(dataset, ina)
  if ( sum(id > 0) )  dataset[, id] <- rnorm(rows * length(id) )
  #how many tests
  nTests = cols
  #data structure to be returned
  univariateModels = NULL;
  univariateModels$pvalue = numeric(nTests) 
  univariateModels$stat = numeric(nTests)
  univariateModels$flag = numeric(nTests);
  #univariateModels$uniModelFit = rep(NA,nTests);
  test_results = NULL;
  #for way to initialize the univariateModel
  #FOR LOOP IS FASTER THAN VAPPLY IN THIS CASE (try apply withm margin 2)
  if ( ncores == 1 | is.null(ncores) | ncores <= 0 ) {
    
    for(i in 1:nTests) {
      test_results = test(target, reps, group, dataset, i, 0, wei = wei, dataInfo = dataInfo, slopes = slopes)
      univariateModels$pvalue[[i]] = test_results$pvalue;
      univariateModels$stat[[i]] = test_results$stat;
      univariateModels$flag[[i]] = test_results$flag;
      univariateModels$stat_hash = test_results$stat_hash
      univariateModels$pvalue_hash = test_results$pvalue_hash      
    } 
    return(univariateModels);
  } else {
    #require(doParallel, quiet = TRUE, warn.conflicts = FALSE)  
    cl <- makePSOCKcluster(4)
    registerDoParallel(cl)
    test = test
    mod <- foreach(i = 1:nTests, .combine = rbind, .export = "lmer", .packages = "lme4") %dopar% {
      ## arguments order for any CI test are fixed
      test_results = test(target, reps, group, dataset, i, 0, wei = wei, dataInfo=dataInfo, slopes = slopes)
      return( c(test_results$pvalue, test_results$stat, test_results$flag, test_results$stat_hash, test_results$pvalue_hash) )
    }
    stopCluster(cl)
    univariateModels$pvalue = as.vector( mod[, 1] )
    univariateModels$stat = as.vector( mod[, 2] )
    univariateModels$flag = as.vector( mod[, 3] )
  }
  
  if ( !is.null(univariateModels) )  {
    univariateModels$flag = numeric(cols) + 1  
    if (targetID != - 1) {
      univariateModels$stat[targetID] = 0
      univariateModels$pvalue[targetID] = log(1)
    }
    if ( sum(id>0) > 0 ) {
      univariateModels$stat[id] = 0
      univariateModels$pvalue[id] = log(1)
    }
  }
}
