% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bsper.R
\name{Bsper}
\alias{Bsper}
\title{Bartlett's Sphericity Test}
\usage{
Bsper(data)
}
\arguments{
\item{data}{a data frame.}
}
\value{
a list with 4 elements:
\item{ChiSquare}{The value of Test Statistic}
\item{df}{The Chi-Square statistic's degree of freedom}
\item{p.value}{p value}
\item{R}{Correlation matrix}
}
\description{
\code{Bsper} function tests whether a correlation matrix is equal to 
the identity matrix or not.
}
\details{
This function computes  Bartlett's test statistic for Sphericity Test. 
The hypotheses are \code{H0:R is equal to I} and \code{H1:R is not equal to I.}
}
\examples{
data(iris) 
results <- Bsper(data=iris[,1:4])
summary(results)
}
\references{
Tatlidil, H. (1996). Uygulamali Cok Degiskenli Istatistiksel Yontemler. Cem Web.
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
