% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstats.R
\name{Get_UV_from_varU}
\alias{Get_UV_from_varU}
\title{Compute the summary statistics given the score statistics and their variance.}
\usage{
Get_UV_from_varU(U, varU, R)
}
\arguments{
\item{U}{a numeric list, each sublist containing score summary statistics \eqn{U} for each study. In each study, a numeric \eqn{m \times K} matrix with each row as a SNP and each column as a separate trait. The number of traits and the number of SNPs in each study can be different but their names are required.}

\item{varU}{a numeric list, each sublist containing the variance of score summary statistics information for each study. In each study, a numeric \eqn{m \times K} matrix with each row as a SNP and each column as a separate trait.}

\item{R}{a SNP correlation matrix, which should contain the correlation of all the SNPs in these studies.}
}
\value{
A list containing summary statistics for each traits, the score summary statistics \eqn{U} and their covariance matrix \eqn{V}.
}
\description{
This function allows you to calculate the score summary statistics \eqn{U} and their covariance matrix \eqn{V} for MTAR, given the score summary statistics and their variance.
}
\examples{
data("varU.example")
attach(varU.example)
obs.stat <- Get_UV_from_varU(U = U, varU = varU, R= R)
obs.stat
detach(varU.example)
}
\author{
Lan Luo
}
